﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Stany magazynowe - szczegóły</title>

	<script runat="server">
		
        ObrotyParams obrotyParams = null;
		void DataContext_ContextLoad(Object sender, EventArgs args)
		{
            obrotyParams = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
            checkObrotyPars(obrotyParams);                        
			if (obrotyParams.DataStanu != obrotyParams.Okres.Okres.To && obrotyParams.DataStanu != Date.Empty)
			{
				throw new InvalidOperationException("Szczegółowy raport stanu magazynowego może być robiony tylko według stanu aktualnego oraz na koniec okresu magazynowego.");
			}
            this._rh.Title = string.Format(this._rh.Title, obrotyParams.Okres, WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(obrotyParams.Magazyny));
		}

        private void checkObrotyPars(ObrotyParams pars) {
            if (pars == null)
                throw new ArgumentNullException("ObrotyParams pars");
            if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
                throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
        }
        

		void Grid_ItemsGet(Object sender, ItemsGetEventArgs args)
		{
			if (args.Deep == 1)
			{
				Towar t = args.Row as Towar;
				if (t != null)
				{
					Soneta.Business.View vw = t.Module.Magazyny.Zasoby.WgTowar[t, obrotyParams.Okres].CreateView();
					if (obrotyParams.Magazyny.Length > 0)
					{
						vw.Condition &= new FieldCondition.In("Magazyn", obrotyParams.Magazyny);
					}
					args.Enumerable = vw;
				}
			}
		}

		void Grid_BeforeRow(Object sender, RowEventArgs args)
		{
			Zasob z = (Zasob)args.Row;
			args.VisibleRow = z.Partia.Typ == TypPartii.Magazynowy;
		}
		
	</script>

	<meta content="C#" name="CODE_LANGUAGE" />
	<meta content="JavaScript" name="vs_defaultClientScript" />
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
	<form id="Form1" method="post" runat="server">
	<ea:DataContext runat="server" OnContextLoad="DataContext_ContextLoad" ID="dc"></ea:DataContext>
	<eb:reportheader runat="server" id="_rh" title="Stany magazynowe - szczegóły|</strong>Okres magazynowy: <strong>{0}|</strong>Magazyn: <strong>{1}</strong>"></eb:reportheader>
	<ea:Grid runat="server" RowTypeName="Soneta.Magazyny.Zasob,Soneta.Handel" OnItemsGet="Grid_ItemsGet"
		GroupData0="Towar.Nazwa" GroupLine="Towar: {1} - {0}" ShowGroupSum="True" GroupData1="Towar.Kod"
		OnBeforeRow="Grid_BeforeRow" EncodeHTML="true">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"
				runat="server">
			</ea:GridColumn>
			<ea:GridColumn Caption=" " EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="20" Align="Right" DataMember="Partia.Dokument" Total="Info"
				Caption="Dokument" EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" DataMember="IlośćZasobu" Total="Sum" Caption="Ilość"
				EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" DataMember="Partia.Cena" Caption="Cena"
				Format="{0:n}" EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" DataMember="Partia.Wartosc" Total="Sum" Caption="Wartość"
				Format="{0:n}" EncodeHTML="True" runat="server">
			</ea:GridColumn>
		</Columns>
	</ea:Grid>
	<eb:reportfooter runat="server" PrintDate="true" PrintTime="true"></eb:reportfooter>
	</form>
</body>
</html>

